package com.yd.csf.feign.request.appointment;

import com.yd.csf.feign.dto.appointment.*;
import com.yd.question.feign.dto.ApiAnswerSessionsDto;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * 新增预约入参
 */
@Data
public class ApiAppointmentAddRequest {

    /**
     * 预约信息（包含签约信息）
     */
    @Valid
    private ApiAppointmentInfoDto apiAppointmentInfoDto;

    /**
     * 产品计划信息
     */
    @Valid
    private ApiProductPlanInfoDto apiProductPlanInfoDto;

    /**
     * 投保人信息
     */
    @Valid
    private ApiPolicyholderInfoDto apiPolicyholderInfoDto;

    /**
     * 受保人信息
     */
    private ApiInsurantInfoDto apiInsurantInfoDto;

    /**
     * 受益人封装对象
     */
    @Valid
    private ApiBeneficiaryInfoFzDto apiBeneficiaryInfoFzDto;

    /**
     * 第二持有人信息
     */
    private ApiSecondHolderInfoDto apiSecondHolderInfoDto;


}
