package com.yd.csf.feign.request.appointment;

import com.yd.csf.feign.dto.appointment.*;
import com.yd.question.feign.dto.ApiAnswerSessionsDto;
import lombok.Data;

import java.util.List;

@Data
public class ApiAppointmentEditStorageRequest {

    /**
     * 预约信息
     */
    private ApiAppointmentInfoDto apiAppointmentInfoDto;

    /**
     * 产品计划信息
     */
    private ApiProductPlanInfoDto apiProductPlanInfoDto;

    /**
     * 投保人信息
     */
    private ApiPolicyholderInfoDto apiPolicyholderInfoDto;

    /**
     * 受保人信息
     */
    private ApiInsurantInfoDto apiInsurantInfoDto;

    /**
     * 受益人封装信息
     */
    private ApiBeneficiaryInfoFzDto apiBeneficiaryInfoFzDto;

    /**
     * 第二持有人信息
     */
    private ApiSecondHolderInfoDto apiSecondHolderInfoDto;

    /**
     * 健康信息 - 答题会话对象（实际回答问题的内容）集合，对象即ApiAnswerSessionsDto，一个对象一个问卷问题
     */
    private List<ApiAnswerSessionsDto> answerSessionsDtoList;
}
