package com.yd.csf.feign.fallback.expectedfortune;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.expectedfortune.ApiExpectedFortuneFeignClient;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-预计发佣信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExpectedFortuneFeignFallbackFactory implements FallbackFactory<ApiExpectedFortuneFeignClient> {
    @Override
    public ApiExpectedFortuneFeignClient create(Throwable cause) {
        return new ApiExpectedFortuneFeignClient() {
            @Override
            public Result<ApiGenerateExpectedFortuneResponse> generate(ApiGenerateExpectedFortuneRequest request) {
                return null;
            }

            @Override
            public Result page(ApiExpectedFortunePageRequest request) {
                return null;
            }
        };
    }
}
