package com.yd.csf.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.api.service.ApiAppointmentUserSignLogService;
import com.yd.csf.feign.dto.appointment.ApiAppointmentUserSignDto;
import com.yd.csf.service.model.AppointmentUserSignLog;
import com.yd.csf.service.service.IAppointmentUserSignLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiAppointmentUserSignLogServiceImpl implements ApiAppointmentUserSignLogService {

    @Autowired
    private IAppointmentUserSignLogService iAppointmentUserSignLogService;

    /**
     * 保存预约签单员列表日志
     * @param userSignDtoList
     * @param appointmentLogBizId
     * @return
     */
    @Override
    public Result saveAppointmentUserSignLogList(List<ApiAppointmentUserSignDto> userSignDtoList,
                                                 String appointmentLogBizId) {
        if (CollectionUtils.isEmpty(userSignDtoList)) {
            return Result.success();
        }
        List<AppointmentUserSignLog> saveList = userSignDtoList.stream().map(dto -> {
            AppointmentUserSignLog log = new AppointmentUserSignLog();
            BeanUtils.copyProperties(dto,log);
            log.setAppointmentLogBizId(appointmentLogBizId);
            log.setAppointmentUserSignLogBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_APPOINTMENT_USER_SIGN_LOG.getCode()));
            return log;
        }).collect(Collectors.toList());

        iAppointmentUserSignLogService.saveOrUpdateBatch(saveList);
        return Result.success();
    }
}
