package com.yd.csf.feign.client.commissionruleconfig;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.commissionruleconfig.ApiCommissionRuleConfigFeignFallbackFactory;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigAddRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigEditRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigPageRequest;
import com.yd.csf.feign.response.commissionruleconfig.ApiCommissionRuleConfigDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-基本法配置信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiCommissionRuleConfigFeignFallbackFactory.class)
public interface ApiCommissionRuleConfigFeignClient {

    /**
     * 分页查询-基本法配置信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiCommissionRuleConfigPageRequest request);

    /**
     * 详情-基本法配置信息
     * @param ruleBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiCommissionRuleConfigDetailResponse> detail(@NotBlank(message = "基本法配置表唯一业务ID不能为空不能为空") @RequestParam(value = "ruleBizId") String ruleBizId);

    /**
     * 添加-基本法配置信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated  @RequestBody ApiCommissionRuleConfigAddRequest request);

    /**
     * 编辑-基本法配置信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiCommissionRuleConfigEditRequest request);

    /**
     * 删除-基本法配置信息 TODO
     * @param ruleBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "基本法配置表唯一业务ID不能为空不能为空") @RequestParam(value = "ruleBizId") String ruleBizId);
}
