package com.yd.csf.service.dto;

import com.yd.csf.feign.dto.appointment.*;
import com.yd.csf.service.model.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 新单跟进聚合查询结果DTO
 */
@Data
public class PolicyFollowAggregateDto implements Serializable {
    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID")
    private String policyBizId;

     /**
     * 客户业务ID
     */
    @Schema(description = "客户业务ID")
    private String customerBizId;

    /**
     * 保单产品计划（保单）
     */
    @Schema(description = "保单产品计划（保单）")
    private ApiProductPlanInfoDto apiProductPlanInfoDto;

    /**
     * 保单投保人
     */
    @Schema(description = "保单投保人")
    private ApiPolicyholderInfoDto apiPolicyholderInfoDto;

    /**
     * 保单受保人
     */
    @Schema(description = "保单受保人")
    private ApiInsurantInfoDto apiInsurantInfoDto;

    /**
     * 保单受益人
     */
    @Schema(description = "保单受益人")
    private List<ApiBeneficiaryInfoDto> apiBeneficiaryInfoDtoList;

    /**
     * 保单第二持有人
     */
    @Schema(description = "保单第二持有人")
    private ApiSecondHolderInfoDto apiSecondHolderInfoDto;

    // todo 健康问卷
//    private Object policyholderInfo;

    // 错误信息（如果有查询失败的情况）
    private String errorMessage;

    private static final long serialVersionUID = 1L;


    public static PolicyFollowAggregateDto convertToDto(Policy policy,
                                                        List<PolicyAdditional> policyAdditionals,
                                                        PolicyPolicyholder policyPolicyholder,
                                                        PolicyInsurant policyInsurant,
                                                        List<PolicyBeneficiary> beneficiaryList,
                                                        PolicySecondHolder policySecondHolder) {
        PolicyFollowAggregateDto dto = new PolicyFollowAggregateDto();
        if (ObjectUtils.isEmpty(policy)) {
            return dto;
        }

        // 设置保单产品计划（保单）
        if (ObjectUtils.isNotEmpty(policy)) {
            ApiProductPlanInfoDto apiProductPlanInfoDto = new ApiProductPlanInfoDto();
            // 产品计划主信息
            ApiProductPlanMainInfoDto apiProductPlanMainInfoDto = new ApiProductPlanMainInfoDto();
            BeanUtils.copyProperties(policy, apiProductPlanMainInfoDto);
            apiProductPlanInfoDto.setApiProductPlanMainInfoDto(apiProductPlanMainInfoDto);

            // 附加险列表
            List<ApiProductPlanAdditionalInfoDto> apiProductPlanAdditionalInfoDtoList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(policyAdditionals)) {
                policyAdditionals.forEach(policyAdditional -> {
                    ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto = new ApiProductPlanAdditionalInfoDto();
                    BeanUtils.copyProperties(policyAdditional, apiProductPlanAdditionalInfoDto);
                    apiProductPlanAdditionalInfoDtoList.add(apiProductPlanAdditionalInfoDto);
                });
            }
            apiProductPlanInfoDto.setApiProductPlanAdditionalInfoDtoList(apiProductPlanAdditionalInfoDtoList);
        }
        // 设置保单投保人
        if (ObjectUtils.isNotEmpty(policyPolicyholder)) {
            ApiPolicyholderInfoDto apiPolicyholderInfoDto = new ApiPolicyholderInfoDto();
            BeanUtils.copyProperties(policyPolicyholder, apiPolicyholderInfoDto);
            dto.setApiPolicyholderInfoDto(apiPolicyholderInfoDto);
        }
        // 设置保单受保人
        if (ObjectUtils.isNotEmpty(policyInsurant)) {
            ApiInsurantInfoDto apiInsurantInfoDto = new ApiInsurantInfoDto();
            BeanUtils.copyProperties(policyInsurant, apiInsurantInfoDto);
            dto.setApiInsurantInfoDto(apiInsurantInfoDto);
        }
        // 设置保单受益人
        if (CollectionUtils.isNotEmpty(beneficiaryList)) {
            List<ApiBeneficiaryInfoDto> apiBeneficiaryInfoDtoList = new ArrayList<>();
            beneficiaryList.forEach(beneficiary -> {
                ApiBeneficiaryInfoDto apiBeneficiaryInfoDto = new ApiBeneficiaryInfoDto();
                BeanUtils.copyProperties(beneficiary, apiBeneficiaryInfoDto);
                apiBeneficiaryInfoDtoList.add(apiBeneficiaryInfoDto);
            });
            dto.setApiBeneficiaryInfoDtoList(apiBeneficiaryInfoDtoList);
        }
        // 设置保单第二持有人
        if (ObjectUtils.isNotEmpty(policySecondHolder)) {
            ApiSecondHolderInfoDto apiSecondHolderInfoDto = new ApiSecondHolderInfoDto();
            BeanUtils.copyProperties(policySecondHolder, apiSecondHolderInfoDto);
            dto.setApiSecondHolderInfoDto(apiSecondHolderInfoDto);
        }

        return dto;
    }
}