package com.yd.csf.feign.fallback.policyreceipt;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.policyreceipt.ApiPolicyReceiptFeignClient;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptAddRequest;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptEditRequest;
import com.yd.csf.feign.request.policyreceipt.ApiPolicyReceiptPageRequest;
import com.yd.csf.feign.response.policyreceipt.ApiPolicyReceiptDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 香港保险服务-保单回执信息Feign降级处理
 */
@Slf4j
@Component
public class ApiPolicyReceiptFeignFallbackFactory implements FallbackFactory<ApiPolicyReceiptFeignClient> {
    @Override
    public ApiPolicyReceiptFeignClient create(Throwable cause) {
        return new ApiPolicyReceiptFeignClient() {
            @Override
            public Result page(ApiPolicyReceiptPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiPolicyReceiptDetailResponse> detail(String policyReceiptBizId) {
                return null;
            }

            @Override
            public Result add(ApiPolicyReceiptAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiPolicyReceiptEditRequest request) {
                return null;
            }

            @Override
            public Result editReceiptStatus(String policyReceiptBizId, String receiptStatus) {
                return null;
            }
        };
    }
}
