package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

@Data
public class PolicyFollowUpdateRequest {
    /**
     * 新单编号
     */
    @Schema(description = "新单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 新单修改Dto
     */
    @Schema(description = "新单修改Dto")
    private PolicyFollowUpdateDto policyFollowUpdateDto;

    /**
     * 转介人列表
     */
    @Schema(description = "转介人列表")
    private List<PolicyBrokerDto> brokerList;

    /**
     * 核保信息
     */
    @Schema(description = "核保信息")
    private VerifyPolicyInfo verifyPolicyInfo;

    /**
     * 保单邮寄
     */
    @Schema(description = "保单邮寄")
    private PolicyMailing policyMailing;
}
