package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.model.PolicyFollowRecord;
import com.yd.csf.service.service.PolicyFollowRecordService;
import com.yd.csf.service.dao.PolicyFollowRecordMapper;
import com.yd.csf.service.vo.PolicyFollowRecordVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author Zhang Jianan
* @description 针对表【policy_follow_record(新单跟进记录表)】的数据库操作Service实现
* @createDate 2025-10-28 17:29:50
*/
@Service
public class PolicyFollowRecordServiceImpl extends ServiceImpl<PolicyFollowRecordMapper, PolicyFollowRecord>
    implements PolicyFollowRecordService{

    @Override
    public List<PolicyFollowRecordVO> getVOList(List<PolicyFollowRecord> policyFollowStatusList) {
        if (CollectionUtils.isEmpty(policyFollowStatusList)) {
            return Collections.emptyList();
        }
        return policyFollowStatusList.stream()
                .map(PolicyFollowRecordVO::objToVO)
                .collect(Collectors.toList());
    }
}




