package com.yd.csf.service.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 应收款管理统计VO
 */
@Data
public class CommissionExpectedStatisticsVO {
    /**
     * 预计入账金额（HKD）
     */
    @Schema(description = "预计入账金额（HKD）")
    private BigDecimal totalAmount;

    /**
     * 已入账金额（HKD）
     */
    @Schema(description = "已入账金额（HKD）")
    private BigDecimal totalPaidAmount;

    /**
     * 待入账金额（HKD）
     */
    @Schema(description = "待入账金额（HKD）")
    private BigDecimal pendingPaidAmount;

    /**
     * 已入账比例 %（已入账金额/总金额）
     */
    @Schema(description = "已入账比例 %（已入账金额/总金额）")
    private BigDecimal paidAmountRatio;

    /**
     * 总保单数
     */
    @Schema(description = "总保单数")
    private Integer totalPolicyCount;
}
