package com.yd.csf.feign.request.expectedfortune;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class ExpectedFortuneAddRequest {
    /**
     * 应付款类型 R-关联保单应付款 U-非关联保单应付款
     */
    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款")
    private String fortuneBizType;

    /**
     * 关联保单号
     */
    @Schema(description = "关联保单号")
    private String policyNo;

    /**
     * 产品计划 ID
     */
    @Schema(description = "产品计划 ID")
    private String productLaunchBizId;

    /**
     * 佣金期数
     */
    @Schema(description = "佣金期数")
    private Integer fortunePeriod;

    /**
     * 总期数
     */
    @Schema(description = "总期数")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "broker biz id")
    private String brokerBizId;

    /**
     * 团队名称
     */
    @Schema(description = "团队名称")
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队 biz id")
    private String teamBizId;

    /**
     * 出账项目
     */
    @Schema(description = "出账项目")
    private String fortuneName;

    /**
     * 出账项目类型
     */
    @Schema(description = "出账项目类型 字典值：csf_fortune_type")
    private String fortuneType;

    /**
     * 出账金额
     */
    @Schema(description = "出账金额")
    private BigDecimal amount;

    /**
     * 出账币种
     */
    @Schema(description = "出账币种")
    private String currency;

    /**
     * 出账日 (估)
     */
    @Schema(description = "出账日 (估)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate payoutDate;

    /**
     * 出账日 (实)
     */
    @Schema(description = "出账日 (实)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate actualPayoutDate;

    /**
     * 出账状态
     */
    @Schema(description = "出账状态 0=待出账 1=可出帐，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出帐，检核完成 7=未找到当前预计发佣对应的来佣, 字典值: csf_expected_fortune_status")
    private String status;

}
