package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.dto.ApiExpectedFortunePageResponseVO;
import com.yd.csf.api.dto.PayableReportResponse;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.request.expectedfortune.ExpectedFortuneAddRequest;
import com.yd.csf.feign.request.expectedfortune.ExpectedFortuneUpdateRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import com.yd.csf.service.dto.QueryPolicyAndBrokerDto;
import com.yd.csf.service.model.CommissionRuleBinding;
import com.yd.csf.service.model.ExpectedFortune;
import com.yd.csf.service.vo.ExpectedFortuneStatisticsVO;
import org.springframework.scheduling.annotation.Async;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface ApiExpectedFortuneService {
    Result<ApiGenerateExpectedFortuneResponse> generate(ApiGenerateExpectedFortuneRequest request);

    @Async("asyncQueryExecutor")
    Result execute(List<QueryPolicyAndBrokerDto> queryPolicyAndBrokerDtoList,
                   List<CommissionRuleBinding> commissionRuleBindingList,
                   String policyNo);

    Result<IPage<ApiExpectedFortunePageResponse>> page(ApiExpectedFortunePageRequest request);

    QueryWrapper<ExpectedFortune> getQueryWrapper(ApiExpectedFortunePageRequest request);

    Result<Boolean> isGenerate(String policyNo);

    Result batchDelByPolicyNo(String policyNo);

    ExpectedFortuneStatisticsVO getStatistics(List<Long> expectedFortuneIds);

    Boolean update(ExpectedFortuneUpdateRequest request);

    Result<ApiExpectedFortunePageResponseVO> list(ApiExpectedFortunePageRequest request);

    Boolean add(List<ExpectedFortuneAddRequest> request);

    void exportExpectedFortune(ApiExpectedFortunePageRequest request, HttpServletResponse response);

    Result<PayableReportResponse> payableReport(ApiExpectedFortunePageRequest request);
}
