package com.yd.csf.service.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.enums.PolicyFollowStatusEnum;
import com.yd.csf.service.model.PolicyBroker;
import com.yd.csf.service.model.PolicyFollow;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 新单跟进详情VO
 */
@Data
@Schema(description = "新单跟进详情")
public class PolicyFollowDetailVO implements Serializable {
    /**
     * id
     */
    @Schema(description = "policy follow id")
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 流程业务ID
     */
    @Schema(description = "流程业务ID")
    private String fnaBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    @Schema(description = "预约信息主表唯一业务ID")
    private String appointmentBizId;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 客户业务id
     */
    @Schema(description = "客户业务ID")
    private String customerBizId;

    /**
     * 递交日期
     */
    @Schema(description = "递交日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate;

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 签单人
     */
    @Schema(description = "签单人")
    private String signer;

    /**
     * 签单人业务id
     */
    @Schema(description = "签单人业务ID")
    private String signerBizId;

    /**
     * 签单人执业编号
     */
    @Schema(description = "签单人执业编号")
    private String signerRegNo;

    /**
     * 签单地点
     */
    @Schema(description = "签单地点")
    private String signLocation;

    /**
     * 缮发日期
     */
    @Schema(description = "缮发日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issueDate;

    /**
     * 冷静期结束日期
     */
    @Schema(description = "冷静期结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date coolingOffEndDate;

    /**
     * 冷静期天数
     */
    @Schema(description = "冷静期天数")
    private Integer coolingOffDays;

    /**
     * 核保日期
     */
    @Schema(description = "核保日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date underwritingDate;

    /**
     * 生效日期
     */
    @Schema(description = "生效日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 续保日期
     */
    @Schema(description = "续保日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalDate;

    /**
     * 保单回执日期
     */
    @Schema(description = "保单回执日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiptDate;

    /**
     * 回执状态
     */
    @Schema(description = "回执状态")
    private String receiptStatus;

    /**
     * 是否开通直接支付
     */
    @Schema(description = "是否开通直接支付")
    private Integer directPaymentEnabled;

    /**
     * 供款年期
     */
    @Schema(description = "供款年期")
    private Integer issueNumber;

    /**
     * 保障期限
     */
    @Schema(description = "保障期限")
    private Integer guaranteePeriod;

    /**
     * 保额（重疾险）
     */
    @Schema(description = "保额（重疾险）")
    private BigDecimal sumInsured;

    /**
     * 付款频率（字典）
     */
    @Schema(description = "付款频率")
    private String paymentFrequency;

    /**
     * 每期保费
     */
    @Schema(description = "每期保费")
    private BigDecimal eachIssuePremium;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepay;

    /**
     * 是否追溯: 0-否, 1-是
     */
    @Schema(description = "是否追溯: 0-否, 1-是")
    private Integer isTraceable;

    /**
     * 回溯日期
     */
    @Schema(description = "回溯日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date retroactiveDate;

    /**
     * 预缴年期
     */
    @Schema(description = "预缴年期")
    private Integer prepaidTerm;

    /**
     * 预付额
     */
    @Schema(description = "预付额")
    private String prepaidAmount;

    /**
     * 折扣后预付额
     */
    @Schema(description = "折扣后预付额")
    private String prepaidAmountAfterDiscount;

    /**
     * 保单截止日期
     */
    @Schema(description = "保单截止日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date policyExpirationDate;

    /**
     * 缴费编号
     */
    @Schema(description = "缴费编号")
    private String paymentNumber;

    /**
     * 产品上架信息表唯一业务ID
     */
    @Schema(description = "产品上架信息表唯一业务ID")
    private String productLaunchBizId;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 产品类别
     */
    @Schema(description = "产品类别")
    private String productCate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务ID")
    private String insuranceCompanyBizId;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务ID")
    private String reconciliationCompanyBizId;

    /**
     * 新单跟进状态
     */
    @Schema(description = "新单跟进状态")
    private String status;

    /**
     * 下一步跟进状态列表
     */
    @Schema(description = "下一步跟进状态列表")
    private Object nextStatusList;

    /**
     * 保單持有人
     */
    @Schema(description = "保单持有人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 受保人年龄
     */
    @Schema(description = "受保人年龄")
    private Integer insuredAge;

    /**
     * 宽限期
     */
    @Schema(description = "宽限期")
    private Integer gracePeriod;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    @Schema(description = "是否参加递增保障权益: 0-否, 1-是")
    private Integer isJoin;

    /**
     * 保单币种
     */
    @Schema(description = "保单币种")
    private String policyCurrency;

    /**
     * 首期付款方式（字典）
     */
    @Schema(description = "首期付款方式")
    private String initialPaymentMethod;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private BigDecimal initialPremium;

    /**
     * 首期已缴保费
     */
    @Schema(description = "首期已缴保费")
    private BigDecimal initialPremiumPaid;

    /**
     * 首期待缴保费
     */
    @Schema(description = "首期待缴保费")
    private BigDecimal initialPremiumDue;

    /**
     * 首期缴费总额
     */
    @Schema(description = "首期缴费总额")
    private BigDecimal initialPremiumTotal;

    /**
     * 首期缴费状态
     */
    @Schema(description = "首期缴费状态")
    private String initialPaymentStatus;

    /**
     * 首期保费优惠金额
     */
    @Schema(description = "首期保费优惠金额")
    private BigDecimal initialPremiumDiscount;

    /**
     * 寄送方式 字典值：1-自提 2-快递
     */
    @Schema(description = "寄送方式 1-自提 2-快递")
    private String mailingMethod;

    /**
     * 续期付款方式（字典）
     */
    @Schema(description = "续期付款方式")
    private String renewalPaymentMethod;

    /**
     * 红利付款方式（字典）
     */
    @Schema(description = "红利付款方式")
    private String dividendPaymentMethod;

    /**
     * 快递单号
     */
    @Schema(description = "快递单号")
    private String deliveryNo;

    /**
     * 保单征费
     */
    @Schema(description = "保单征费")
    private String policyLevy;

    /**
     * 最晚缴费日期
     */
    @Schema(description = "最晚缴费日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date latestPaymentDate;

    /**
     * 经纪公司签收日期
     */
    @Schema(description = "经纪公司签收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date brokerSignDate;

    /**
     * 保险公司寄出日期
     */
    @Schema(description = "保险公司寄出日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insurerMailingDate;

    /**
     * 客户签收日期
     */
    @Schema(description = "客户签收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date customerSignDate;

    /**
     * 附件地址列表 逗号隔开
     */
    @Schema(description = "附件地址列表")
    private String attachments;

    /**
     * 转介人列表
     */
    @Schema(description = "转介人列表")
    private List<PolicyBroker> brokerList;

    /**
     * 附加险列表
     */
    @Schema(description = "附加险列表")
    private List<PolicyAdditionalVO> additionalList;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @Schema(description = "删除标识: 0-正常, 1-删除")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @Schema(description = "创建人ID")
    private String creatorId;

    /**
     * 更新人ID
     */
    @Schema(description = "更新人ID")
    private String updaterId;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /**
     * 对象转封装类
     *
     * @param policyFollow 新单跟进实体
     * @return PolicyFollowDetailVO
     */
    public static PolicyFollowDetailVO objToVo(PolicyFollow policyFollow) {
        if (policyFollow == null) {
            return null;
        }
        PolicyFollowDetailVO detailVO = new PolicyFollowDetailVO();
        detailVO.setPolicyBizId(policyFollow.getPolicyBizId());
        // 转换PolicyFollow
        BeanUtils.copyProperties(policyFollow, detailVO);
        // 处理 nextStatusList 字段
        Object nextStatusList = policyFollow.getNextStatusList();
        if (nextStatusList != null && !nextStatusList.toString().isEmpty()) {
            String[] statusArr = nextStatusList.toString().split(",");
            List<Map<String, String>> statusMapList = new ArrayList<>();
            for (String status : statusArr) {
                Map<String, String> map = new HashMap<>();
                PolicyFollowStatusEnum statusEnum = PolicyFollowStatusEnum.getEnumByValue(status);
                if (statusEnum != null) {
                    map.put("itemLabel", statusEnum.getItemLabel());
                    map.put("itemValue", status);
                }
                statusMapList.add(map);
            }
            detailVO.setNextStatusList(statusMapList);
        }

        return detailVO;
    }
}
