package com.yd.csf.feign.client.appointmentfile;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointmentfile.ItineraryDto;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentImportExcelRequest;
import com.yd.csf.feign.fallback.appointmentfile.ApiAppointmentFileFeignFallbackFactory;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileAddRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileEditRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFilePageRequest;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentExportExcelResponse;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentImportExcelResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-预约附件信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiAppointmentFileFeignFallbackFactory.class)
public interface ApiAppointmentFileFeignClient {

    /**
     * 预约附件信息分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiAppointmentFilePageRequest request);

    /**
     * 新增预约附件信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiAppointmentFileAddRequest request);

    /**
     * 编辑预约附件信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiAppointmentFileEditRequest request);

    /**
     * 删除预约附件
     * @param appointmentFileBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "预约附件信息表唯一业务ID不能为空") @RequestParam(value = "appointmentFileBizId") String appointmentFileBizId);

    /**
     * 下载预约附件
     * @param appointmentFileBizId
     * @return
     */
    @GetMapping("/download")
    Result download(@NotBlank(message = "预约附件信息表唯一业务ID不能为空") @RequestParam(value = "appointmentFileBizId") String appointmentFileBizId);

    /**
     * 生成行程单PDF
     * @param appointmentBizId
     * @return
     */
    @GetMapping("/pdf/itinerary")
    Result<String> itineraryPdf(@NotBlank(message = "预约信息主表唯一业务ID不能为空") @RequestParam(value = "appointmentBizId") String appointmentBizId);

    /**
     * 获取行程单详情
     * @param appointmentBizId
     * @return
     */
    @GetMapping("/pdf/itinerary/detail")
    Result<ItineraryDto> itineraryDetail(@NotBlank(message = "预约信息主表唯一业务ID不能为空") @RequestParam(value = "appointmentBizId") String appointmentBizId);

    /**
     * Excel导出-预约信息
     * @param appointmentBizId
     * @return
     */
    @GetMapping("/excel/export/appointment")
    Result<ApiAppointmentExportExcelResponse> appointmentExportExcel(@NotBlank(message = "预约信息主表唯一业务ID不能为空") @RequestParam(value = "appointmentBizId") String appointmentBizId);

    /**
     * Excel导入-解析Excel预约信息
     * @return
     */
    @PostMapping(value = "/excel/import/appointment")
    Result<ApiAppointmentImportExcelResponse> appointmentImportExcel(
                                                                    @RequestParam("file") MultipartFile file,
                                                                    ApiAppointmentImportExcelRequest request);
}
