package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class FortuneStatisticsVO {
    /**
     * 入账金额
     */
    @Schema(description = "入账金额")
    private BigDecimal totalInAmount;

    /**
     * 总保单数
     */
    @Schema(description = "总保单数")
    private Long totalPolicyCount;

    /**
     * 总保费
     */
    @Schema(description = "总保费")
    private BigDecimal totalPremium;

    /**
     * 待出账金额
     */
    @Schema(description = "待出账金额")
    private BigDecimal pendingOutAmount;

    /**
     * 可出账账金额
     */
    @Schema(description = "可出账金额")
    private BigDecimal availableOutAmount;

}
