package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 查询customer请求
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PolicyFollowQueryRequest extends PageDto implements Serializable {

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 新单跟进状态
     */
    @Schema(description = "新单状态, 字典值: csf_policy_follow_status")
    private String status;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 签单日开始
     */
    @Schema(description = "签单日期开始 格式: yyyy-MM-dd", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDateStart;

    /**
     * 签单日结束
     */
    @Schema(description = "签单日期结束 格式: yyyy-MM-dd", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDateEnd;

    /**
     * 最晚缴费日期
     */
    @Schema(description = "最晚缴费日期 格式: yyyy-MM-dd", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date latestPaymentDate;

    /**
     * 投保人业务id列表
     */
//    @Schema(description = "投保人业务id列表")
//    private List<String> policyholderBizIdList;

    /**
     * 受保人业务id列表
     */
//    @Schema(description = "受保人业务id列表")
//    private List<String> policyInsurantBizIdList;

    /**
     * 保险公司业务id列表
     */
    @Schema(description = "保险公司业务id列表")
    private List<String> insuranceCompanyBizIdList;

    /**
     * 产品计划业务id列表
     */
    @Schema(description = "产品计划业务id列表")
    private List<String> productLaunchBizIdList;

    /**
     * 缴费年期
     */
    @Schema(description = "缴费年期")
    private String issueNumber;

    private static final long serialVersionUID = 1L;
}