package com.yd.csf.feign.dto.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 预约信息
 */
@Data
public class ApiAppointmentInfoDto {

    /**
     * 预约信息表主键id（新增不需要传值，修改需要传值）
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String appointmentBizId;

    /**
     * 预约编号（和预约信息主表唯一业务ID是一对，唯一，冗余字段）
     */
    private String appointmentNo;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String customerNo;

    /**
     * 关联FNA信息表唯一业务ID（冗余字段）
     */
    private String fnaBizId;

    /**
     * 关联FNA编号（和FNA信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String fnaNo;

    /**
     * 关联计划书信息表唯一业务ID（冗余字段）
     */
    private String proposalBizId;

    /**
     * 关联计划书编号（和计划书信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String proposalNo;

    /**
     * 申请类型（字典）
     */
//    @NotBlank(message = "申请类型不能为空")
    private String applyType;

    /**
     * 业务编号
     */
    private String businessNo;

    /**
     * 确定预约时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime confirmAppointmentTime;

    /**
     * 意向预约时间
     */
//    @NotNull(message = "意向预约时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime intentionAppointmentTime;

    /**
     * 顾问是否陪同: 0-否, 1-是（字典）
     */
    private Integer isAccompany;

    /**
     * 陪同顾问姓名（FNA Form有填写，可带入）
     */
    private String accompanyName;

    /**
     * 陪同顾问手机区号
     */
    private String accompanyMobileCode;

    /**
     * 陪同顾问手机
     */
    private String accompanyMobile;

    /**
     * 陪同顾问邮箱
     */
    private String accompanyEmail;

    /**
     * 到港时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime arrivalTime;

    /**
     * 离港时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime departureTime;

    /**
     * 会面地点（字典）
     */
    private String meetingPoint;

    /**
     * 签单地址
     */
    private String signingAddress;

    /**
     * 客户在港期间联络电话区号
     */
    private String hkMobileCode;

    /**
     * 客户在港期间联络电话
     */
    private String hkMobile;

    /**
     * 是否开户: 0-否, 1-是（字典）
     */
    private Integer isOpenAccount;

    /**
     * 开户行名称
     */
    private String bankName;

    /**
     * 开户行支行（分行）
     */
    private String bankBranchName;

    /**
     * 开户时间段（开始）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openAccountStartTime;

    /**
     * 开户时间段（结束）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openAccountEndTime;

    /**
     * 开户地点
     */
    private String openAccountLocation;

    /**
     * 开户须知
     */
    private String openAccountNotice;

    /**
     * 是否体检: 0-否, 1-是（字典）
     */
    private Integer isTj;

    /**
     * 是否购买过香港保险: 0-否, 1-是（字典）
     */
    private Integer isBuy;

    /**
     * 转保声明选项: 0-否, 1-是 2-尚未決定（字典）
     */
    private Integer policyTransfer;

    /**
     * 业务代表1账号
     */
    private String businessRepresentAccount1;

    /**
     * 业务代表1姓名
     */
    private String businessRepresentName1;

    /**
     * 业务代表1电话号码区号
     */
    private String businessRepresentMobile1Code;

    /**
     * 业务代表1电话号码
     */
    private String businessRepresentMobile1;

    /**
     * 业务代表1邮箱
     */
    private String businessRepresentEmail1;

    /**
     * 是否有用车服务：0-否, 1-是（字典）
     */
    private Integer isUseCar;

    /**
     * 创建人用户名
     */
    private String creatorName;
}
