package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.csf.service.dto.PolicyQueryRequest;

import com.yd.csf.service.model.Policy;
import com.yd.csf.service.service.PolicyService;
import com.yd.csf.service.vo.PolicyVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * policy接口
 *
 * @author jianan
 * @since 2025-09-20
 */
@RestController
@RequestMapping("/policy")
@Tag(name = "保单接口")
public class ApiPolicyController {

    @Resource
    private PolicyService policyService;


    /**
     * 创建保单
     *
     * @param customerAddRequest
     * @param request
     * @return
     */
//    @Operation(summary = "创建保单")
//    @PostMapping("/add")
//    @Transactional(rollbackFor = Exception.class)
//    public Result<Map<String, Object>> addCustomer(@RequestBody CustomerAddRequest customerAddRequest, HttpServletRequest request) {
//        if (customerAddRequest == null) {
//            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
//        }
//        return Result.success(PolicyService.addCustomer(customerAddRequest));
//    }

    /**
     * 删除fna
     *
     * @param deleteRequest
     * @param request
     * @return
     */
//    @PostMapping("/delete")
//    public Result<Boolean> deleteFna(@RequestBody DeleteRequest deleteRequest, HttpServletRequest request) {
//        if (deleteRequest == null || deleteRequest.getId() <= 0) {
//            throw new BusinessException(ErrorCode.PARAMS_ERROR);
//        }
//        User user = userService.getLoginUser(request);
//        long id = deleteRequest.getId();
//        // 判断是否存在
//        Customer oldFna = PolicyService.getById(id);
//        ThrowUtils.throwIf(oldFna == null, ErrorCode.NOT_FOUND_ERROR);
//        // 仅本人或管理员可删除
//        if (!oldFna.getUserId().equals(user.getId()) && !userService.isAdmin(request)) {
//            throw new BusinessException(ErrorCode.NO_AUTH_ERROR);
//        }
//        // 操作数据库
//        boolean result = PolicyService.removeById(id);
//        ThrowUtils.throwIf(!result, ErrorCode.OPERATION_ERROR);
//        return Result.success(true);
//    }

    /**
     * 更新保单
     *
     * @param PolicyUpdateRequest
     * @return
     */
//    @PostMapping("/update")
//    @Operation(summary = "更新保单信息")
//    public Result<Boolean> updatePolicy(@RequestBody PolicyUpdateRequest PolicyUpdateRequest) {
//        if (PolicyUpdateRequest == null || PolicyUpdateRequest.getPolicyBizId() == null) {
//            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
//        }
//        return Result.success(PolicyService.updatePolicy(PolicyUpdateRequest));
//    }

    /**
     * 根据 policyBizId 获取保单（封装类）
     *
     * @param policyBizId
     * @return
     */
//    @GetMapping("/get/vo")
//    @Operation(summary = "根据 policyBizId 获取保单详情")
//    public Result<PolicyVO> getPolicyByPolicyBizId(@RequestParam("policyBizId") String policyBizId, HttpServletRequest request) {
//        if (policyBizId == null) {
//            return Result.fail(ErrorCode.PARAMS_ERROR.getCode(), ErrorCode.PARAMS_ERROR.getMessage());
//        }
//        // 查询数据库
//        Policy Policy = PolicyService.getByPolicyBizId(policyBizId);
//        if (Policy == null) {
//            return Result.fail(ErrorCode.NOT_FOUND_ERROR.getCode(), ErrorCode.NOT_FOUND_ERROR.getMessage());
//        }
//
//        // 获取封装类
//        return Result.success(PolicyService.getPolicyVO(Policy));
//    }
    
    /**
     * 分页获取保单列表（VO）
     *
     * @param PolicyQueryRequest
     * @param request
     * @return
     */
    @PostMapping("/list/page/vo")
    @Operation(summary = "分页获取保单列表")
    public Result<Page<PolicyVO>> listPolicyByPage(@RequestBody PolicyQueryRequest PolicyQueryRequest,
                                                               HttpServletRequest request) {
        long current = PolicyQueryRequest.getPageNo();
        long size = PolicyQueryRequest.getPageSize();

        // 查询数据库
        Page<Policy> policyPage = policyService.page(new Page<>(current, size),
                policyService.getQueryWrapper(PolicyQueryRequest));
        // 获取封装类
        return Result.success(policyService.getPolicyVOPage(policyPage));
    }

}
