package com.yd.csf.service.vo;

import cn.hutool.json.JSONUtil;

import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.FnaForm;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Fna表单视图
 *
 */
@Data
public class FnaFormVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * fna唯一业务ID
     */
    @Schema(description = "fna唯一业务ID")
    private String fnaFormBizId;


    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 个人资料
     */
    @Schema(description = "个人资料")
    private PersonalData personalData;

    /**
     * 家庭状况
     */
    @Schema(description = "家庭状况")
    private List<FamilyMember> familyMembers;

    /**
     * 保单持有人个人已有保障
     */
    @Schema(description = "保单持有人个人已有保障")
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 受保人个人已有保障
     */
    @Schema(description = "受保人个人已有保障")
    private List<ExistingSecurity> existingSecurityInsured;

    /**
     * 收支情况
     */
    @Schema(description = "收支情况")
    private IncomeExpense incomeExpense;

    /**
     * 流动资产
     */
    @Schema(description = "流动资产")
    private LiquidAssets liquidAssets;

    /**
     * 自住用途之房地產
     */
    @Schema(description = "自住用途之房地產")
    private List<OwnerProperties> primaryResidence;

    /**
     * 投資房地產
     */
    @Schema(description = "投資房地產")
    private List<InvestmentProperties> investment;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    /**
     * 其他问题
     */
    @Schema(description = "Fna表单其他问题")
    private FnaFormOther other;

    /**
     * 封装类转对象
     *
     * @param fnaFormVO
     * @return
     */
    public static FnaForm voToObj(FnaFormVO fnaFormVO) {
        if (fnaFormVO == null) {
            return null;
        }
        FnaForm fnaForm = new FnaForm();
        BeanUtils.copyProperties(fnaFormVO, fnaForm);

        return fnaForm;
    }

    /**
     * 对象转封装类
     *
     * @param fnaForm
     * @return
     */
    public static FnaFormVO objToVo(FnaForm fnaForm) {
        if (fnaForm == null) {
            return null;
        }
        FnaFormVO fnaFormVO = new FnaFormVO();
        BeanUtils.copyProperties(fnaForm, fnaFormVO);

        return fnaFormVO;
    }
}
