package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 第二持有人信息表
 * @TableName policy_second_holder
 */
@TableName(value ="policy_second_holder")
@Data
public class PolicySecondHolder implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 第二持有人信息表唯一业务ID
     */
    private String policySecondHolderBizId;

    /**
     * 新单跟进业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 与受保人关系（字典）
     */
    private String insurantRel;

    /**
     * 名字
     */
    private String name;

    /**
     * 名字-英文
     */
    private String nameEn;

    /**
     * 性别（字典）
     */
    private String gender;

    /**
     * 证件类型（字典）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 护照号码
     */
    private String passportNumber;

    /**
     * 出生日期
     */
    private Date birthTime;

    /**
     * 年龄
     */
    private String age;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}