package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保单佣金计算结果表（出账表） - 存储佣金计算的详细结果，用于查询、对账和发放
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("commission_result")
public class CommissionResult implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 发佣批次表唯一业务ID
     */
    @TableField("batch_biz_id")
    private String batchBizId;

    /**
     * 保单表唯一业务ID
     */
    @TableField("policy_biz_id")
    private String policyBizId;

    /**
     * 业务员ID（会员唯一业务ID）
     */
    @TableField("agent_id")
    private String agentId;

    /**
     * 佣金金额（出账金额）
     */
    @TableField("commission_amount")
    private BigDecimal commissionAmount;

    /**
     * 出账时间，记录该条佣金结果的出账时间
     */
    @TableField("billing_date")
    private LocalDateTime billingDate;

    /**
     * 出账状态：待出账、出账中、已出账、出账失败
     */
    @TableField("status")
    private String status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
