package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.dto.ApiExpectedFortunePageResponseVO;
import com.yd.csf.api.dto.PayableReportResponse;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.request.expectedfortune.ApiGenerateExpectedFortuneRequest;
import com.yd.csf.feign.request.expectedfortune.ExpectedFortuneAddRequest;
import com.yd.csf.feign.request.expectedfortune.ExpectedFortuneUpdateRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.feign.response.expectedfortune.ApiGenerateExpectedFortuneResponse;
import com.yd.csf.service.dto.QueryPolicyAndBrokerDto;
import com.yd.csf.service.model.CommissionRuleBinding;
import com.yd.csf.service.model.ExpectedFortune;
import com.yd.csf.service.vo.ExpectedFortuneStatisticsVO;
import org.springframework.scheduling.annotation.Async;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface ApiExpectedFortuneService {
    Result<ApiGenerateExpectedFortuneResponse> generate(ApiGenerateExpectedFortuneRequest request);

    /**
     * 生成预计发佣（包含日志记录和Redis处理）
     * 用于内部服务调用，会自动保存日志和异常时销毁Redis缓存
     * @param request
     * @return
     */
    Result<ApiGenerateExpectedFortuneResponse> generateWithLogAndRedis(ApiGenerateExpectedFortuneRequest request);

    Result<ApiGenerateExpectedFortuneResponse> generateSyncWithLogAndRedis(ApiGenerateExpectedFortuneRequest request);

    @Async("asyncQueryExecutor")
    Result execute(List<QueryPolicyAndBrokerDto> queryPolicyAndBrokerDtoList,
                   List<CommissionRuleBinding> commissionRuleBindingList,
                   String policyNo);

    /**
     * 同步执行预计发佣生成
     * @param queryPolicyAndBrokerDtoList 保单和转介人列表
     * @param commissionRuleBindingList 基本法绑定列表
     * @param policyNo 保单号
     * @return 执行结果
     */
    Result executeSync(List<QueryPolicyAndBrokerDto> queryPolicyAndBrokerDtoList,
                       List<CommissionRuleBinding> commissionRuleBindingList,
                       String policyNo);

    Result<IPage<ApiExpectedFortunePageResponse>> page(ApiExpectedFortunePageRequest request);

    QueryWrapper<ExpectedFortune> getQueryWrapper(ApiExpectedFortunePageRequest request);

    Result<Boolean> isGenerate(String policyNo);

    Result batchDelByPolicyNo(String policyNo);

    ExpectedFortuneStatisticsVO getStatistics(List<Long> expectedFortuneIds);

    Boolean update(ExpectedFortuneUpdateRequest request);

    Result<ApiExpectedFortunePageResponseVO> list(ApiExpectedFortunePageRequest request);

    Boolean add(List<ExpectedFortuneAddRequest> request);

    void exportExpectedFortune(ApiExpectedFortunePageRequest request, HttpServletResponse response);

    Result<PayableReportResponse> payableReport(ApiExpectedFortunePageRequest request);
}
