package com.yd.csf.api.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.auth.core.utils.SecurityUtil;
import com.yd.common.enums.CommonEnum;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.enums.CommissionStatusEnum;
import com.yd.csf.service.model.Commission;
import lombok.Data;

import javax.crypto.SecretKey;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionExcelDTO {
    @ExcelProperty("保单号")
    private String policyNo;

    @ExcelProperty("对账公司")
    private String reconciliationCompany;

    @ExcelProperty("当前来佣期数")
    private Integer commissionPeriod;

    @ExcelProperty("来佣总期数")
    private Integer totalPeriod;

    @ExcelProperty("来佣项目")
    private String commissionName;

    @ExcelProperty("来佣金额")
    private BigDecimal amount;

    @ExcelProperty("来佣币种")
    private String currency;

    @ExcelProperty("来佣日期")
    private Date commissionDate;

    @ExcelProperty("备注")
    private String remark;

    /**
     * 数据转换
     */
    public static Commission convertToEntity(CommissionExcelDTO data, String loginUserId) {
        Commission entity = new Commission();
        // 字段映射
        entity.setPolicyNo(data.getPolicyNo());
        entity.setCommissionBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_COMMISSION.getCode()));
        entity.setReconciliationCompany(data.getReconciliationCompany());
        entity.setCommissionPeriod(data.getCommissionPeriod());
        entity.setTotalPeriod(data.getTotalPeriod());
        entity.setCommissionName(data.getCommissionName());
        entity.setAmount(data.getAmount());
        entity.setCurrency(data.getCurrency());
        entity.setCommissionDate(data.getCommissionDate());
        entity.setRemark(data.getRemark());
        entity.setStatus(CommissionStatusEnum.UNCOMPARE.getItemValue());
        entity.setCreatorId(loginUserId);
        entity.setUpdaterId(loginUserId);
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return entity;
    }
}
