package com.yd.csf.service.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionVO implements Serializable {

    /**
     * 保单来佣业务id
     */
    private String commissionBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionType;

    /**
     * 来佣金额
     */
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    private String currency;

    /**
     * 来佣日期
     */
    private Date commissionDate;

    /**
     * 来佣状态 0=未比对 1=已比对
     */
    private String status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    private static final long serialVersionUID = 1L;
}
