package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
public class AttachmentUploadRequest implements Serializable {
    /**
     * 新单跟进bizId
     */
    @Schema(description = "新单跟进bizId", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 中台文件元数据表唯一业务ID
     */
    @NotBlank(message = "中台文件元数据表唯一业务ID不能为空")
    @Schema(description = "中台文件元数据表唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String ossFileBizId;

    /**
     * 文件名
     */
    @NotBlank(message = "文件名不能为空")
    @Schema(description = "文件名", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fileName;

    /**
     * 文件访问路径
     */
    @NotBlank(message = "文件访问路径为空")
    @Schema(description = "文件访问路径", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fileUrl;

    private static final long serialVersionUID = 1L;
}
