package com.yd.csf.feign.dto.premiumremittance;

import com.yd.csf.feign.dto.premiumremittancefile.ApiPremiumRemittanceFileDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ApiPremiumRemittanceDto {

    /**
     * 保费对账-汇款记录表唯一业务ID（传值编辑，不传值新增）
     */
    private String premiumRemittanceBizId;

    /**
     * 保费对账记录表唯一业务ID
     */
    private String premiumReconciliationBizId;

    /**
     * 缴费方式
     */
    @NotBlank(message = "缴费方式不能为空")
    private String paymentMethod;

    /**
     * 付款金额
     */
    @NotNull(message = "付款金额不能为空")
    private BigDecimal paymentAmount;

    /**
     * 付款币种
     */
    @NotBlank(message = "付款币种不能为空")
    private String paymentCurrency;

    /**
     * 付款人与保单关系（字典）
     */
    @NotBlank(message = "付款人与保单关系不能为空")
    private String paymentRel;

    /**
     * 付款人
     */
    @NotBlank(message = "付款人不能为空")
    private String payer;

    /**
     * 付款银行
     */
    private String payingBank;

    /**
     * 付款账号
     */
    private String paymentAccount;

    /**
     * 支付凭证列表
     */
    @NotEmpty(message = "支付凭证列表不能为空")
    private List<String> paymentVoucherList;

    /**
     * 账户证明列表
     */
    @NotEmpty(message = "账户证明列表不能为空")
    private List<String> accountVerificationList;

    /**
     * 其他资料列表
     */
    private List<ApiPremiumRemittanceFileDto> apiPremiumRemittanceFileDtoList;
}
