package com.yd.csf.feign.request.premiumreconciliation;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class ApiCalculateRemainingUnpaidAmountRequest {

    /**
     * 保费对账记录表唯一业务ID
     */
    @NotBlank(message = "保费对账记录表唯一业务ID不能为空")
    private String premiumReconciliationBizId;

    /**
     * 当次保司认定金额（客户当次缴纳的金额）
     */
    @NotNull(message = "当次保司认定金额不能为空")
    private BigDecimal recognizedAmount;

    /**
     * 当次保司认定币种
     */
    @NotNull(message = "当次保司认定币种不能为空")
    private String recognizedCurrency;

}
