package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class PayableReportVO {
    /**
     * 应付款编号
     */
    @Schema(description = "应付款编号")
    private String payableNo;

    /**
     * 保单号
     */
    @Schema(description = "policy no")
    private String policyNo;

    /**
     * 转介人
     */
    @Schema(description = "转介人(保单的第一位转介人)")
    private String broker;

    /**
     * 出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "出账期数")
    private Integer fortunePeriod;

    /**
     * 总期数
     */
    @Schema(description = "总期数")
    private Integer fortuneTotalPeriod;

    /**
     * 出账日
     */
    @Schema(description = "出账日 (保单日+2个月)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate payoutDate;

    /**
     * 已出账比例 已出账金额/应出账金额
     */
    @Schema(description = "已出账比例 已出账金额/应出账金额")
    private BigDecimal paidRatio;

    /**
     * 待出账比例 待出账金额/应出账金额
     */
    @Schema(description = "待出账比例 待出账金额/应出账金额")
    private BigDecimal unpaidRatio;

    /**
     * 已出账金额
     */
    @Schema(description = "已出账金额")
    private BigDecimal paidAmount;

    /**
     * 待出账金额
     */
    @Schema(description = "待出账金额")
    private BigDecimal unpaidAmount;

    /**
     * 应出账金额（预计发佣金额 = 标准发佣金额 * 转介人介绍费占比）
     */
    @Schema(description = "应出账金额（预计发佣金额 = 标准发佣金额 * 转介人介绍费占比）")
    private BigDecimal amount;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal premium;

    /**
     * 出账币种
     */
    @Schema(description = "出账币种")
    private String currency;

    /**
     * 应出账金额（港币）
     */
    @Schema(description = "应出账金额（港币）")
    private BigDecimal hkdAmount;

    /**
     * 保险公司 ID
     */
    @Schema(description = "保险公司 ID")
    private String insuranceCompanyBizId;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insuranceCompany;

    /**
     * 产品计划 ID
     */
    @Schema(description = "产品计划 ID")
    private String productLaunchBizId;

    /**
     * 产品计划
     */
    @Schema(description = "产品计划")
    private String productName;
}
