package com.yd.csf.feign.dto.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 产品计划主信息
 */
@Data
public class ApiProductPlanMainInfoDto {

    /**
     * 产品计划表主键id（新增不需要传值，编辑需要传值）
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID（新增不需要传值，编辑需要传值）
     */
    private String appointmentBizId;

    /**
     * 产品计划信息表唯一业务ID（新增不需要传值，编辑需要传值）
     */
    private String planBizId;

    /**
     * 保险产品唯一业务ID（中台保险产品业务id，冗余）
     */
//    @NotBlank(message = "保险产品唯一业务ID不能为空")
    private String productBizId;

    /**
     * 保险产品名称（中台保险产品名称，冗余）
     */
//    @NotBlank(message = "保险产品名称不能为空")
    private String productName;

    /**
     * 保险公司名称（冗余字段）
     */
    private String companyName;

    /**
     * 地区
     */
    private String region;

    /**
     * 货币（字典）
     */
//    @NotBlank(message = "货币不能为空")
    private String currency;

    /**
     * 供款年期（字典）
     */
//    @NotBlank(message = "供款年期不能为空")
    private String paymentTerm;

    /**
     * 付款频率（字典）
     */
//    @NotBlank(message = "付款频率不能为空")
    private String paymentFrequency;

    /**
     * 每期保费
     */
//    @NotNull(message = "每期保费不能为空")
    private BigDecimal eachIssuePremium;

    /**
     * 保额
     */
//    @NotNull(message = "保额不能为空")
    private BigDecimal sumInsured;

    /**
     * 是否预缴保费: 0-否, 1-是（字典）
     */
//    @NotNull(message = "是否预缴保费不能为空")
    private Integer isPrepay;

    /**
     * 预付额
     */
    private BigDecimal deductibles;

    /**
     * 首期付款方式（字典）
     */
    private String initialPaymentMethod;

    /**
     * 续期付款方式（字典）
     */
    private String renewalPaymentMethod;

    /**
     * 红利分配方式（字典）
     */
    private String dividendDistributionMethod;

    /**
     * 保单日期回溯: 0-否, 1-是（字典）
     */
    private Integer isBacktrack;

    /**
     * 保单生效日
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime policyEffectiveDate;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    private Integer isJoin;
}
