package com.yd.csf.service.vo;

import com.yd.csf.feign.enums.PaymentFrequencyEnum;
import com.yd.csf.service.model.Fna;
import com.yd.csf.service.model.PolicyAdditional;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 保单附加险VO
 */
@Data
@Schema(description = "保单附加险信息")
public class PolicyAdditionalVO implements Serializable {

    /**
     * 主键ID
     */
    @Schema(description = "policy additional id")
    private Long id;

    /**
     * 新单跟进-保单附加险信息表唯一业务ID
     */
    @Schema(description = "新单跟进-保单附加险信息表唯一业务ID")
    private String policyAdditionalBizId;

    /**
     * 新单跟进业务ID
     */
    @Schema(description = "新单跟进业务ID")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 产品计划信息表唯一业务ID
     */
    @Schema(description = "产品计划信息表唯一业务ID")
    private String planBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    @Schema(description = "产品上架信息表唯一业务ID")
    private String productLaunchBizId;

    /**
     * 产品上架信息表名称
     */
    @Schema(description = "品上架信息表名称")
    private String productLaunchName;

    /**
     * 付款频率（字典）
     */
    @Schema(description = "付款频率（字典）")
    private String paymentFrequency;

    /**
     * 保障年期
     */
    @Schema(description = "保障年期")
    private String guaranteePeriod;

    /**
     * 保单币种
     */
    @Schema(description = "保单币种")
    private String policyCurrency;

    /**
     * 供款期数
     */
    @Schema(description = "供款期数")
    private String issueNumber;

    /**
     * 每期保费
     */
    @Schema(description = "每期保费")
    private BigDecimal eachIssuePremium;

    private static final long serialVersionUID = 1L;


    /**
     * 对象转封装类
     *
     * @param policyAdditional
     * @return
     */
    public static PolicyAdditionalVO objToVo(PolicyAdditional policyAdditional) {
        if (policyAdditional == null) {
            return null;
        }
        PolicyAdditionalVO policyAdditionalVO = new PolicyAdditionalVO();
        BeanUtils.copyProperties(policyAdditional, policyAdditionalVO);

        return policyAdditionalVO;
    }

    /**
     * 根据付款频率字典值获取中文标签
     *
     * @param paymentFrequency 付款频率字典值
     * @return 中文标签
     */
    public static String getPaymentFrequencyLabel(String paymentFrequency) {
        if (paymentFrequency == null) {
            return null;
        }
        for (PaymentFrequencyEnum enumItem : PaymentFrequencyEnum.values()) {
            if (enumItem.getItemValue().equals(paymentFrequency)) {
                return enumItem.getItemLabel();
            }
        }
        return paymentFrequency;
    }
}
