package com.yd.csf.feign.client.basiclawcalculate;

import com.yd.common.result.Result;
import com.yd.csf.feign.fallback.basiclawcalculate.ApiBasicLawCalculateFeignFallbackFactory;
import com.yd.csf.feign.request.basiclawcalculate.ApiGenerateBillingRequest;
import com.yd.csf.feign.response.basiclawcalculate.ApiGenerateBillingResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 香港保险服务-基本法计算接口信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiBasicLawCalculateFeignFallbackFactory.class)
public interface ApiBasicLawCalculateFeignClient {

    /**
     * 生成出账
     * @param request
     * @return
     */
    @PostMapping("/generate/billing")
    Result<ApiGenerateBillingResponse> generateBilling(@Validated @RequestBody ApiGenerateBillingRequest request);
}
