package com.yd.csf.service.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 佣金统计VO 包含总金额、总入账金额、待入账金额、已入账比例（已入账金额/总金额）、总保单数
 */
@Data
public class CommissionStatisticsVO {

    /**
     * 总金额
     */
    @Schema(description = "总金额")
    private BigDecimal totalAmount;

    /**
     * 总入账金额
     */
    @Schema(description = "总入账金额")
    private BigDecimal totalPaidAmount;

    /**
     * 待入账金额
     */
    @Schema(description = "待入账金额")
    private BigDecimal pendingPaidAmount;

    /**
     * 已入账比例（已入账金额/总金额）
     */
    @Schema(description = "已入账比例（已入账金额/总金额）")
    private BigDecimal paidAmountRatio;

    /**
     * 总保单数
     */
    @Schema(description = "总保单数")
    private Integer totalPolicyCount;
}
