package com.yd.csf.feign.request.conditiontype;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiConditionTypeEditRequest {

    /**
     * 条件类型表唯一业务ID
     */
    @NotBlank(message = "条件类型表唯一业务ID不能为空")
    private String conditionTypeBizId;

    /**
     * 条件类型名称
     */
    @NotBlank(message = "条件类型名称不能为空")
    private String name;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;
}
