package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;

@Data
public class FortuneAccountQueryRequest extends PageDto {

    @Schema(description = "转介人")
    private String broker;

    @Schema(description = "所属团队")
    private String team;

    @Schema(description = "出账状态 可出账、待出账、已出账")
    private String status;

    @Schema(description = "出账日期开始", example = "2023-01-01", type = "string", format = "date")
    private Date accountDateStart;

    @Schema(description = "出账日期结束", example = "2023-01-01", type = "string", format = "date")
    private Date accountDateEnd;
}
