package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CommissionAddRequest implements Serializable {
    /**
     * 保单号
     */
    @Schema(description = "保单号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司", requiredMode = Schema.RequiredMode.REQUIRED)
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)", requiredMode = Schema.RequiredMode.REQUIRED)
    private Integer commissionPeriod;

    /**
     * 佣金列表
     */
    @Schema(description = "佣金列表", requiredMode = Schema.RequiredMode.REQUIRED)
    private List<CommissionAddDto> commissionAddDtoList;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
