package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.FortuneAccountAddRequest;
import com.yd.csf.service.dto.FortuneAccountExportDTO;
import com.yd.csf.service.dto.FortuneAccountQueryRequest;
import com.yd.csf.service.dto.FortuneAccountUpdateRequest;
import com.yd.csf.service.model.FortuneAccount;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.vo.FortuneAccountVO;

import java.util.List;
import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【fortune_account(出账记录表)】的数据库操作Service
* @createDate 2025-09-23 15:45:32
*/
public interface FortuneAccountService extends IService<FortuneAccount> {

    QueryWrapper<FortuneAccount> getQueryWrapper(FortuneAccountQueryRequest fortuneAccountQueryRequest);

    Page<FortuneAccountVO> getFortuneAccountVOPage(Page<FortuneAccount> fortunePage);

    void saveFortuneAccount(List<FortuneAccountExportDTO> accountExportDTOList);

    FortuneAccount getByFortuneAccountBizId(String fortuneAccountBizId);

    Map<String, Object> addFortuneAccount(FortuneAccountAddRequest fortuneAccountAddRequest);

    Boolean updateFortuneAccount(FortuneAccountUpdateRequest fortuneAccountUpdateRequest);
}
