package com.yd.csf.feign.client.premiumremittancefile;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.premiumremittancefile.ApiPremiumRemittanceFileDto;
import com.yd.csf.feign.fallback.premiumremittancefile.ApiPremiumRemittanceFileFeignFallbackFactory;
import com.yd.csf.feign.request.premiumremittancefile.ApiPremiumRemittanceFilePageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-保费汇款记录附件信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiPremiumRemittanceFileFeignFallbackFactory.class)
public interface ApiPremiumRemittanceFileFeignClient {

    /**
     * 分页列表查询-保费汇款记录附件信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiPremiumRemittanceFilePageRequest request);

    /**
     * 添加-保费汇款记录附件信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiPremiumRemittanceFileDto request);

    /**
     * 编辑-保费汇款记录附件信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiPremiumRemittanceFileDto request);

    /**
     * 删除-保费汇款记录附件信息
     * @param premiumRemittanceFileBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "保费汇款记录附件表唯一业务ID能为空") @RequestParam(value = "premiumRemittanceFileBizId") String premiumRemittanceFileBizId);
}
