package com.yd.csf.feign.response.approval;

import lombok.Data;

@Data
public class ApiApprovalClientUserPageResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 证件类型
     */
    private String idCardType;

    /**
     * 证件号码
     */
    private String idCardNumber;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 审批状态
     */
    private String approvalStatus;

    /**
     * 注册来源（PC、小程序等）默认小程序 - MINI_PROGRAM
     */
    private String registerSource;

    /**
     * 邀请码
     */
    private String invitationCode;

    /**
     * 推荐来源（PC、小程序等，字典，PC就是中台加入申请的）
     */
    private String source;

    /**
     * 推荐人ID（客户端用户表唯一业务ID，如果是PC，这里就是sys_user的用户ID）
     */
    private String referrerId;

    /**
     * 推荐人账号（客户端用户表手机号，如果是PC，这里就是sys_user的用户名）
     */
    private String referrerAccount;
}
