package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiAppointmentFileService;
import com.yd.csf.feign.client.appointmentfile.ApiAppointmentFileFeignClient;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileAddRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFileEditRequest;
import com.yd.csf.feign.request.appointmentfile.ApiAppointmentFilePageRequest;
import com.yd.csf.feign.response.appointmentfile.ApiAppointmentFilePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 预约附件信息
 *
 * @author zxm
 * @since 2025-09-01
 */
@RestController
@RequestMapping("/appointmentFile")
@Validated
public class ApiAppointmentFileController implements ApiAppointmentFileFeignClient {

    @Autowired
    private ApiAppointmentFileService apiAppointmentFileService;

    /**
     * 预约附件信息分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAppointmentFilePageResponse>> page(ApiAppointmentFilePageRequest request) {
        return apiAppointmentFileService.page(request);
    }

    /**
     * 新增预约附件信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiAppointmentFileAddRequest request) {
        return apiAppointmentFileService.add(request);
    }

    /**
     * 编辑预约附件信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiAppointmentFileEditRequest request) {
        return apiAppointmentFileService.edit(request);
    }

    /**
     * 删除预约附件
     * @param appointmentFileBizId
     * @return
     */
    @Override
    public Result del(String appointmentFileBizId) {
        return apiAppointmentFileService.del(appointmentFileBizId);
    }

    /**
     * 下载预约附件
     * @param appointmentFileBizId
     * @return
     */
    @Override
    public Result download(String appointmentFileBizId) {
        return apiAppointmentFileService.download(appointmentFileBizId);
    }
}
