package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 创建Fna表单请求
 *
 */
@Data
public class FnaFormAddRequest implements Serializable {

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 个人资料
     */
    @Schema(description = "个人资料")
    private PersonalData personalData;

    /**
     * 家庭状况
     */
    @Schema(description = "家庭状况（父亲-father/母亲-mother/配偶-spouse/子女-children）")
    private List<FamilyMember> familyMembers;

    /**
     * 保单持有人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 受保人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityInsured;

    /**
     * 平均月收入
     */
    @Schema(description = "平均月收入")
    private String monthlyIncome;

    /**
     * 平均月支出
     */
    @Schema(description = "平均月支出")
    private String monthlyExpense;

    /**
     * 累积流动资产
     */
    @Schema(description = "累积流动资产")
    private String liquidAssets;

    /**
     * 流动资产种类（A.现金 B.银行存款……）
     */
    @Schema(description = "流动资产种类（A.现金 B.银行存款……）")
    private String liquidAssetType;

    /**
     * 保单持有人资产
     */
    @Schema(description = "保单持有人资产")
    private OwnerAssets ownerAssets;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    @Schema(description = "首期及续保保费的财富来源（A.储蓄 B.受雇收入 C.自雇收入 D.投资收入）")
    private String premiumFundingSource;

    private static final long serialVersionUID = 1L;
}