package com.yd.csf.service.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

@Data
@ToString
@Schema(description = "地址 residenceAddress-居住地址、residentialAddress-住宅地址、mailingAddress-邮寄地址、companyAddress-公司地址")
public class AddressVO implements Serializable {

    @Schema(description = "区域")
    private String region;

    @Schema(description = "城市（省份+城市）")
    private String city;

    @Schema(description = "街道")
    private String street;

    @Schema(description = "详细地址")
    private String location;

    private static final long serialVersionUID = 1L;
}
