package com.yd.csf.feign.request.commissionruleconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
public class ApiCommissionRuleConfigEditRequest {

    /**
     * 基本法配置表唯一业务ID
     */
    @NotBlank(message = "基本法配置表唯一业务ID不能为空")
    private String ruleBizId;

    /**
     * 基本法名称
     */
    @NotBlank(message = "基本法名称不能为空")
    private String ruleName;

    /**
     * 基本法描述
     */
    private String description;

    /**
     * 生效开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime effectiveStart;

    /**
     * 生效结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime effectiveEnd;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 版本号
     */
    private Integer ruleVersion;

//    /**
//     * 所属租户唯一业务ID（冗余）
//     */
//    private String tenantBizId;
//
//    /**
//     * 所属项目唯一业务ID（冗余）
//     */
//    private String projectBizId;


}
