package com.yd.csf.feign.request.policyreceipt;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiPolicyReceiptAddRequest {

    /**
     * 保单号
     */
    @NotBlank(message = "保单号不能为空")
    private String policyNo;

    /**
     * 回执日期
     */
    @NotNull(message = "回执日期不能为空")
    private LocalDateTime receiptDate;

    /**
     * 回执状态（CONFIRMED-已确认 UNCONFIRMED-未确认）
     */
    @NotBlank(message = "回执状态不能为空")
    private String receiptStatus;

    /**
     * 保单持有人签名（图片URL）
     */
    private List<String> policyHolderSignatureList;
}
