package com.yd.csf.feign.dto.appointment;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 受益人信息
 */
@Data
public class ApiBeneficiaryInfoDto {

    /**
     * 受益人信息表主键ID
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 受益人信息表唯一业务ID
     */
    private String beneficiaryBizId;

    /**
     * 与受保人关系（字典）
     */
    private String insurantRel;

    /**
     * 姓名-中文
     */
    private String nameCn;

    /**
     * 姓名-（拼音/英文，通过中文自动加载全部大写的拼音）
     */
    private String namePyEn;

    /**
     * 证件类型（字典，下拉选择）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 性别（字典，如果是身份证，自动获取性别和生日）
     */
    private String gender;

    /**
     * 出生日期（生日，如果是身份证，自动获取性别和生日）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime birthday;

    /**
     * 国籍（下拉选择）
     */
    private String nationality;

    /**
     * 受益比例
     */
    private BigDecimal benefitRatio;

}
