package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 保单受保人信息表
 * @TableName policy_insurant
 */
@TableName(value ="policy_insurant")
@Data
public class PolicyInsurant implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 受保人信息表唯一业务ID
     */
    private String policyInsurantBizId;

    /**
     * 新单跟进业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 客户类型（字典）
     */
    private String customerType;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String customerNo;

    /**
     * 与投保人关系（字典）
     */
    private String policyholderRel;

    /**
     * 名字
     */
    private String name;

    /**
     * 名字-英文
     */
    private String nameEn;

    /**
     * 性别（字典）
     */
    private String gender;

    /**
     * 证件类型（字典）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 出生日期
     */
    private Date birthday;

    /**
     * 年龄
     */
    private String age;

    /**
     * 居住地址
     */
    private String residentialAddress;

    /**
     * 通讯地址
     */
    private String mailingAddress;

    /**
     * 移动电话区号
     */
    private String mobileCode;

    /**
     * 移动电话
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司地址
     */
    private String companyAddress;

    /**
     * 行业
     */
    private String industry;

    /**
     * 职位
     */
    private String position;

    /**
     * 风险偏好（字典）
     */
    private String riskAppetite;

    /**
     * 是否VIP: 0-否, 1-是（字典）
     */
    private Integer isVip;

    /**
     * vip备注
     */
    private String vipRemark;

    /**
     * 称谓（字典）
     */
    private String appellation;

    /**
     * 是否区分吸烟（字典）
     */
    private String smokingAllowed;

    /**
     * 出生地（省市）
     */
    private String birthplace;

    /**
     * 国籍
     */
    private String nationality;

    /**
     * 护照号码
     */
    private String passportNo;

    /**
     * 通行证号码
     */
    private String passNo;

    /**
     * 身高
     */
    private String height;

    /**
     * 体重
     */
    private String weight;

    /**
     * BMI
     */
    private String bmi;

    /**
     * 受雇于现职年期
     */
    private BigDecimal currentTenure;

    /**
     * 总负债额
     */
    private BigDecimal totalDebt;

    /**
     * 受供养人数目
     */
    private Integer dependentsNum;

    /**
     * 婚姻状况（字典）
     */
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    private String educationLevel;

    /**
     * 总工作年期
     */
    private BigDecimal totalWorkingYears;

    /**
     * 现时每月收入
     */
    private BigDecimal currentMonthlyIncome;

    /**
     * 公司电话区号
     */
    private String companyMobileCode;

    /**
     * 公司电话
     */
    private String companyMobile;

    /**
     * 固定电话区号
     */
    private String landlineCode;

    /**
     * 固定电话
     */
    private String landline;

    /**
     * 其他电话
     */
    private String otherMobile;

    /**
     * 过往一年是否所属国家以外地区居住超过182日: 0-否, 1-是（字典）
     */
    private Integer isExceed;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    private Integer isOtherCountry;

    /**
     * 是否接受推广信息: 0-否, 1-是（字典）
     */
    private Integer isPromotion;

    /**
     * 旅行（字典）
     */
    private String travel;

    /**
     * 运动（字典）
     */
    private String exercise;

    /**
     * 游戏（字典）
     */
    private String game;

    /**
     * 电影/戏剧（字典）
     */
    private String movieDrama;

    /**
     * 美食（字典）
     */
    private String delicacy;

    /**
     * 地址列表（json串）
     */
    private Object addressList;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 吸烟量(支/天)
     */
    private String smokingVolume;

    /**
     * 货币（字典）
     */
    private String currency;

    /**
     * 公司名称（英文）
     */
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    private Date companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    private String companyRegisterRegion;

    /**
     * 公司邮箱
     */
    private String companyEmail;

    /**
     * 公司登记地址
     */
    private String companyEnterAddress;

    /**
     * 授权代表姓名中文-名字
     */
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    private String authNameEn;

    /**
     * 授权代表职称
     */
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    private String authMobile;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}