package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 首期缴费保存请求
 */
@Data
public class InitialPaymentSaveRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @Schema(description = "新单跟进唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private BigDecimal initialPremium;

    @Schema(description = "保单征费")
    private String policyLevy;

    @Schema(description = "首期付款方式（字典）")
    private String initialPaymentMethod;

    @Schema(description = "首期已缴保费")
    private BigDecimal initialPremiumPaid;

    @Schema(description = "首期待缴保费")
    private BigDecimal initialPremiumDue;

    @Schema(description = "首期缴费总额")
    private BigDecimal initialPremiumTotal;

    @Schema(description = "缴费状态")
    private String initialPaymentStatus;

    @Schema(description = "最晚缴费日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date latestPaymentDate;

    @Schema(description = "首期保费优惠金额")
    private BigDecimal initialPremiumDiscount;
}
