package com.yd.csf.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.api.service.ApiAppointmentUserSignService;
import com.yd.csf.feign.dto.appointment.ApiAppointmentReferrerDto;
import com.yd.csf.feign.dto.appointment.ApiAppointmentUserSignDto;
import com.yd.csf.service.model.AppointmentReferrer;
import com.yd.csf.service.model.AppointmentUserSign;
import com.yd.csf.service.service.IAppointmentUserSignService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiAppointmentUserSignServiceImpl implements ApiAppointmentUserSignService {

    @Autowired
    private IAppointmentUserSignService iAppointmentUserSignService;

    /**
     * 保存签单员列表信息
     * @param userSignDtoList
     * @param appointmentBizId
     * @return
     */
    @Override
    public Result saveAppointmentUserSignList(List<ApiAppointmentUserSignDto> userSignDtoList, String appointmentBizId) {
        if (CollectionUtils.isEmpty(userSignDtoList)) {
            return Result.success();
        }
        //先删后新增
        iAppointmentUserSignService.delByAppointmentBizId(appointmentBizId);

        //新增
        List<AppointmentUserSign> saveList = userSignDtoList.stream().map(dto -> {
            AppointmentUserSign userSign = new AppointmentUserSign();
            BeanUtils.copyProperties(dto,userSign);
            userSign.setAppointmentBizId(appointmentBizId);
            userSign.setAppointmentUserSignBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_APPOINTMENT_USER_SIGN.getCode()));
            return userSign;
        }).collect(Collectors.toList());
        iAppointmentUserSignService.saveOrUpdateBatch(saveList);

        return Result.success();
    }

    @Override
    public List<ApiAppointmentUserSignDto> userSignDtoList(String appointmentBizId) {
        List<AppointmentUserSign> appointmentUserSignList = iAppointmentUserSignService.queryList(appointmentBizId);
        if (CollectionUtils.isEmpty(appointmentUserSignList)) {
            return new ArrayList<>();
        }
        List<ApiAppointmentUserSignDto> list = appointmentUserSignList.stream().map(dto -> {
            ApiAppointmentUserSignDto appointmentUserSignDto = new ApiAppointmentUserSignDto();
            BeanUtils.copyProperties(dto,appointmentUserSignDto);
            return appointmentUserSignDto;
        }).collect(Collectors.toList());
        return list;
    }
}
