package com.yd.csf.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.api.service.ApiCommissionRuleConfigService;
import com.yd.csf.feign.client.commissionruleconfig.ApiCommissionRuleConfigFeignClient;
import com.yd.csf.feign.request.additional.ApiAdditionalPageRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigAddRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigEditRequest;
import com.yd.csf.feign.request.commissionruleconfig.ApiCommissionRuleConfigPageRequest;
import com.yd.csf.feign.response.commissionruleconfig.ApiCommissionRuleConfigDetailResponse;
import com.yd.csf.feign.response.commissionruleconfig.ApiCommissionRuleConfigPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 基本法配置信息
 *
 * @author zxm
 * @since 2025-10-15
 */
@RestController
@RequestMapping("/commissionRuleConfig")
@Validated
public class ApiCommissionRuleConfigController implements ApiCommissionRuleConfigFeignClient {

    @Autowired
    private ApiCommissionRuleConfigService apiCommissionRuleConfigService;

    /**
     * 分页查询-基本法配置信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiCommissionRuleConfigPageResponse>> page(ApiCommissionRuleConfigPageRequest request) {
        return apiCommissionRuleConfigService.page(request);
    }

    /**
     * 详情-基本法配置信息
     * @param ruleBizId
     * @return
     */
    @Override
    public Result<ApiCommissionRuleConfigDetailResponse> detail(String ruleBizId) {
        return apiCommissionRuleConfigService.detail(ruleBizId);
    }

    /**
     * 添加-基本法配置信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiCommissionRuleConfigAddRequest request) {
        return apiCommissionRuleConfigService.add(request);
    }

    /**
     * 编辑-基本法配置信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiCommissionRuleConfigEditRequest request) {
        return apiCommissionRuleConfigService.edit(request);
    }

    /**
     * 删除-基本法配置信息 TODO
     * @param ruleBizId
     * @return
     */
    @Override
    public Result del(String ruleBizId) {
        return apiCommissionRuleConfigService.del(ruleBizId);
    }
}
