package com.yd.csf.feign.dto.appointment;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 投保人信息
 */
@Data
public class ApiPolicyholderInfoDto {

    /**
     * 投保人信息主键id（新增不需要传值，修改需要传值）
     */
    private Long id;

    /**
     * 预约信息主表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String appointmentBizId;

    /**
     * 投保人信息表唯一业务ID（新增不需要传值，修改需要传值）
     */
    private String policyholderBizId;

    /**
     * 客户类型（字典）
     */
//    @NotBlank(message = "客户类型不能为空")
    private String customerType;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    private String customerNo;

    /**
     * 名字
     */
    private String name;

    /**
     * 名字-英文
     */
    private String nameEn;

    /**
     * 性别（字典）
     */
    private String gender;

    /**
     * 证件类型（字典）
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 出生日期
     */
    private LocalDateTime birthday;

    /**
     * 年龄
     */
    private String age;

    /**
     * 居住地址
     */
    private String residentialAddress;

    /**
     * 移动电话区号
     */
    private String mobileCode;

    /**
     * 移动电话
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 行业
     */
    private String industry;

    /**
     * 职位
     */
    private String position;

    /**
     * 风险偏好（字典）
     */
    private String riskAppetite;

    /**
     * 是否VIP: 0-否, 1-是（字典）
     */
    private Integer isVip;

    /**
     * vip备注
     */
    private String vipRemark;

    /**
     * 称谓（字典）
     */
    private String appellation;

    /**
     * 是否区分吸烟（字典）
     */
    private String smokingAllowed;

    /**
     * 吸烟量(支/天)
     */
    private String smokingVolume;

    /**
     * 出生地（省市）
     */
    private String birthplace;

    /**
     * 国籍
     */
    private String nationality;

    /**
     * 护照号码
     */
    private String passportNo;

    /**
     * 通行证号码
     */
    private String passNo;

    /**
     * 身高
     */
    private String height;

    /**
     * 体重
     */
    private String weight;

    /**
     * BMI
     */
    private String bmi;

    /**
     * 货币（字典）
     */
    private String currency;

    /**
     * 平均每月支出
     */
    private BigDecimal monthExpenditure;

    /**
     * 平均每月收入
     */
    private BigDecimal monthIncome;

    /**
     * 受雇于现职年期
     */
    private BigDecimal currentTenure;

    /**
     * 总流动资产
     */
    private BigDecimal totalCurrentAssets;

    /**
     * 总负债额
     */
    private BigDecimal totalDebt;

    /**
     * 受供养人数目
     */
    private Integer dependentsNum;

    /**
     * 婚姻状况（字典）
     */
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    private String educationLevel;

    /**
     * 总工作年期
     */
    private BigDecimal totalWorkingYears;

    /**
     * 现时每月收入
     */
    private BigDecimal currentMonthlyIncome;

    /**
     * 固定电话
     */
    private String landline;

    /**
     * 过往一年是否所属国家以外地区居住超过182日: 0-否, 1-是（字典）
     */
    private Integer isExceed;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    private Integer isOtherCountry;

    /**
     * 投保人邮政编码
     */
    private String postalCode;

    /**
     * 旅行（字典）
     */
    private String travel;

    /**
     * 运动（字典）
     */
    private String exercise;

    /**
     * 游戏（字典）
     */
    private String game;

    /**
     * 电影/戏剧（字典）
     */
    private String movieDrama;

    /**
     * 美食（字典）
     */
    private String delicacy;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司地址
     */
    private String companyAddress;

    /**
     * 公司电话区号
     */
    private String companyMobileCode;

    /**
     * 公司电话
     */
    private String companyMobile;

    /**
     * 公司名称（英文）
     */
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    private LocalDateTime companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    private String companyRegisterRegion;

    /**
     * 公司邮箱
     */
    private String companyEmail;

    /**
     * 公司登记地址
     */
    private String companyEnterAddress;

    /**
     * 通讯地址
     */
    private String mailingAddress;

    /**
     * 授权代表姓名中文-名字
     */
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    private String authNameEn;

    /**
     * 授权代表职称
     */
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    private String authMobile;

    /**
     * 其他电话
     */
    private String otherMobile;

    /**
     * 是否接受推广信息: 0-否, 1-是（字典）
     */
    private Integer isPromotion;
}
