package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import com.yd.csf.feign.request.appointment.*;
import com.yd.csf.feign.response.appointment.*;
import com.yd.csf.service.model.Appointment;

public interface ApiAppointmentService {
    Result<IPage<ApiAppointmentPageResponse>> page(ApiAppointmentPageRequest request);

    Result<ApiAppointmentDetailResponse> detail(String appointmentBizId);

    Result<ApiAppointmentInfoDto> mainDetail(String appointmentBizId);

    Result<ApiAppointmentAddResponse> add(ApiAppointmentAddRequest request);

    Result addStorage(ApiAppointmentAddStorageRequest request);

    Result edit(ApiAppointmentEditRequest request);

    Result editStorage(ApiAppointmentEditStorageRequest request);

    Result editConfirmTime(ApiAppointmentEditConfirmTimeRequest request);

    Result singleEdit(ApiAppointmentInfoDto apiAppointmentInfoDto);

    Result editFna(ApiAppointmentEditFnaRequest request);

    Result removeFna(ApiAppointmentRemoveFnaRequest request);

    Result editProposal(ApiAppointmentEditProposalRequest request);

    Result removeProposal(ApiAppointmentRemoveProposalRequest request);

    Result editPolicyTransfer(ApiPolicyTransferRequest request);

    Result editStatus(ApiAppointmentEditStatusRequest request);

    Result del(String appointmentBizId);

    Result<IPage<ApiAppointmentLogPageResponse>> logPage(ApiAppointmentLogPageRequest request);

    Result<ApiAppointmentLogDetailResponse> logDetail(String appointmentLogBizId);

    Result<Appointment> checkAppointmentIsExist(String appointmentBizId);
}
